/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;

public record StructureTempData(List<Either<TagKey<Structure>, Structure>> structures, double temperature, Temperature.Units units, boolean isOffset, Optional<List<String>> requiredMods) {
    public static final Codec<StructureTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrVanillaRegistryCodec(Registry.f_235725_, Structure.f_226554_).listOf().fieldOf("structures").forGetter(StructureTempData::structures), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(StructureTempData::temperature), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(StructureTempData::units), (App)Codec.BOOL.optionalFieldOf("offset", (Object)false).forGetter(StructureTempData::isOffset), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(StructureTempData::requiredMods)).apply((Applicative)instance, StructureTempData::new));

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StructureTempData{structures=[");
        for (Either<TagKey<Structure>, Structure> structure : this.structures) {
            if (structure.left().isPresent()) {
                builder.append("#").append(((TagKey)structure.left().get()).toString());
            } else {
                builder.append(((Structure)structure.right().get()).toString());
            }
            builder.append(", ");
        }
        builder.append("], temperature=").append(this.temperature).append(", units=").append((Object)this.units).append(", offset=").append(this.isOffset);
        this.requiredMods.ifPresent(mods -> builder.append(", requiredMods=").append(mods));
        builder.append("}");
        return builder.toString();
    }
}

